<?php

namespace App\Console\Commands;

use App\Enums\NotificationTypesEnum;
use App\Models\FirebaseNotification;
use App\Models\ShopCategory;
use Carbon\Carbon;
use Illuminate\Console\Command;

class CheckShopSubscriptions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'shops:subscriptions {--notification}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check for ended subscription and send warning notification';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
//        $warning7Days = ShopCategory::query()
//            ->whereDate('valid_to' , Carbon::now()->addDays(7)->toDateString())
//            ->where('is_active', 1)
//            ->get()
//            ->each(function ($subscription){
////                $userLang = $subscription->shop->lang;
//                $userId   = HashIdObj()->encode($subscription->user_id);
//                $title_en    = trans('global.subscription_warning_title', [], 'en');
//                $message_en  = trans('global.subscription_warning_body', [
//                    'category_name' =>$subscription->category->en_name,
//                    'expiry_date' => Carbon::now()->addDays($subscription->days_left)->format('d/m/Y'),
//                ], 'en');
//
//                $title_ar    = trans('global.subscription_warning_title', [], 'ar');
//                $message_ar  = trans('global.subscription_warning_body', [
//                    'category_name' =>$subscription->category->ar_name,
//                    'expiry_date' => Carbon::now()->addDays($subscription->days_left)->format('d/m/Y'),
//                ], 'ar');
//
//                $this->sendNotification($userId, $title_en, $message_en,$title_ar,$message_ar);
//            });

        $warning3Days = ShopCategory::query()
            ->whereDate('valid_to' , Carbon::now()->addDays(3)->toDateString())
            ->where('is_active', 1)
            ->get()
            ->each(function ($subscription){
//                $userLang = $subscription->shop->lang;
                $userId   = HashIdObj()->encode($subscription->user_id);
                $title_en    = trans('global.subscription_warning_title', [], 'en');
                $message_en  = trans('global.subscription_warning_body', [
                    'category_name' => $subscription->category->en_name,
                    'expiry_date' => Carbon::now()->addDays($subscription->days_left)->format('d/m/Y'),
                ], 'en');

                $title_ar    = trans('global.subscription_warning_title', [], 'ar');
                $message_ar = trans('global.subscription_warning_body', [
                    'category_name' => $subscription->category->ar_name,
                    'expiry_date' => Carbon::now()->addDays($subscription->days_left)->format('d/m/Y'),
                ], 'ar');
                $this->sendNotification($userId, $title_en, $message_en,$title_ar,$message_ar);
            });;

        $warning1Days = ShopCategory::query()
            ->whereDate('valid_to' , Carbon::now()->addDays(1)->toDateString())
            ->where('is_active', 1)
            ->get()
            ->each(function ($subscription){
//                $userLang = $subscription->shop->lang;
                $userId   = HashIdObj()->encode($subscription->user_id);
                $title_en    = trans('global.subscription_warning_title', [], 'en');
                $message_en  = trans('global.subscription_warning_body', [
                    'category_name' => $subscription->category->en_name,
                    'expiry_date' => Carbon::now()->addDays($subscription->days_left)->format('d/m/Y'),
                ], 'en');
                $title_ar    = trans('global.subscription_warning_title', [], 'en');
                $message_ar  = trans('global.subscription_warning_body', [
                    'category_name' => $subscription->category->ar_name,
                    'expiry_date' => Carbon::now()->addDays($subscription->days_left)->format('d/m/Y'),
                ], 'ar');
                $this->sendNotification($userId, $title_en, $message_en,$title_ar,$message_ar);
            });;

        $unsubscribe = ShopCategory::query()
            ->whereDate('valid_to' , '<=',Carbon::now()->toDateString())
            ->where('is_active', 1)
            ->get()
            ->each(function ($subscription){
//                $userLang = $subscription->shop->lang;
                $userId   = HashIdObj()->encode($subscription->user_id);
                $title_en    = trans('global.unsubscription_title', [], 'en');
                $message_en  = trans('global.unsubscription_body', [
                    'category_name' => $subscription->category->en_name,
                ], 'en');

                $title_ar    = trans('global.unsubscription_title', [], 'ar');
                $message_ar  = trans('global.unsubscription_body', [
                    'category_name' => $subscription->category->ar_name,
                ], 'ar');

                $subscription->update(['is_active' => false]);
                $this->sendNotification($userId, $title_en, $message_en,$title_ar,$message_ar);
            });
        ;

        $this->info("
        warning3Days : {$warning3Days->count()} \n
        warning1Days : {$warning1Days->count()} \n
        unsubscribe  : {$unsubscribe->count()} \n
        options      : {$this->option('notification')} \n
        ");

        return 0;
    }

    private function sendNotification ($userId, $title_en, $message_en,$title_ar,$message_ar, $image=null) {
        $this->info("user-{$userId} -- $title_en -- $message_en");
        $this->info("user-{$userId} -- $title_ar -- $message_ar");

        if($this->option('notification')) {
            FirebaseNotification::query()->create([
                'user_id'   =>  HashIdObj()->decode($userId)[0],
                'title'     =>  $title_en,
                'body'      =>  $message_en,
                'lang'      =>  'en',
                'type'      =>  NotificationTypesEnum::Subscription
            ]);
            FirebaseNotification::query()->create([
                'user_id'   =>  HashIdObj()->decode($userId)[0],
                'title'     =>  $title_ar,
                'body'      =>  $message_ar,
                'lang'      =>  'ar',
                'type'      =>  NotificationTypesEnum::Subscription
            ]);

            $title=$title_en."\n".$title_ar;
            $body =$message_en ."\n".$message_ar;

            fcm()
                ->toTopic("user-$userId")
                ->priority('normal')
                ->timeToLive(0)
                ->notification([
                    'title' =>  $title,
                    'body' =>  $body,
                ])->data([
                    'title' => $title,
                    'body' =>$body,
                ])
                ->send();
        }
    }
}
