<?php

namespace App\Enums;

class SadadStatusEnums
{
    public const SUCCESS = "SUCCESS";
    public const PENDING = "PENDING";
    public const PENDING_CONFIRMATION = "PENDING CONFIRMATION";
    public const FAILED = "FAILED";

    public static function getByCode($code)
    {
        return [
            1   => self::SUCCESS,
            400   => self::PENDING,
            402   => self::PENDING_CONFIRMATION,
            810   => self::FAILED
        ][$code];
    }
}
