<?php

namespace App\Exceptions;

use App\Enums\HttpCodesEnum;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Validation\ValidationException;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     *
     * @return void
     */
    public function register()
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    public function render($request, Throwable $e)
    {
        if ($e instanceof ValidationException && $request->expectsJson()) {
            return response()->json([
                'message' => $e->validator->getMessageBag()->first(),
                'errors' => $e->validator->getMessageBag()
            ], HttpCodesEnum::ValidationError);
        }
        return parent::render($request, $e); // TODO: Change the autogenerated stub
    }

    protected function unauthenticated($request, AuthenticationException $exception)
    {
        if ($request->expectsJson()) {
            return response()->json(['error' => trans('global.unauthenticated')], HttpCodesEnum::Unauthenticated);
        }

        return parent::unauthenticated($request, $exception); // TODO: Change the autogenerated stub
    }
}
