<?php


namespace App\Factory\SMSFactory;

use Illuminate\Support\Facades\Http;

class OoredooSMSFactory extends SMSBase implements SMSFactoryInterface
{
    public function sendMessage($message, $phone) {
        $http = Http::get('https://messaging.ooredoo.qa/bms/soap/Messenger.asmx/HTTP_SendSms', [
            'customerID'        =>  env('SMS_CUSTOMER_ID'),
            'userName'          =>  env('SMS_USERNAME'),
            'userPassword'      =>  env('SMS_PASSWORD'),
            'originator'        =>  env('SMS_USERNAME'),
            'smsText'           =>  $message,
            'recipientPhone'    =>  $phone,
            'messageType'       =>  app()->getLocale() == 'ar' ?'ArabicWithLatinNumbers':'Latin',
            'defDate'           =>  '',
            'blink'             =>  'false',
            'flash'             =>  'false',
            'Private'           =>  'false',
        ]);

//        return simplexml_load_string($http->body());
        return $http->body();

    }

    public function getSmsStatus($id) {
        $http = Http::get('https://messaging.ooredoo.qa/bms/soap/Messenger.asmx/HTTP_GetSmsStatus',[
            'customerID'    =>  env('SMS_CUSTOMER_ID'),
            'userName'          =>  env('SMS_USERNAME'),
            'userPassword'      =>  env('SMS_PASSWORD'),
            'transactionID'      =>  $id,
            'detailed'      =>  'true',
        ]);
//        return simplexml_load_string($http->body());
        return $http->body();
    }
}
