<?php
use App\Enums\HttpCodesEnum;
use App\Models\Country;
use App\Models\Setting;
use Hashids\Hashids;
use App\Enums\SettingsEnum;
use App\Enums\UsersTypesEnums;
use Illuminate\Support\Str;
use \Illuminate\Support\Facades\Storage;

if ( ! function_exists("ValidationError")) {
    function ValidationError($message, ...$errors) {
        return response()->json(['message'=>$message, 'errors' => $errors], HttpCodesEnum::ValidationError);
    }
}

if ( ! function_exists('DefaultCountryId')) {
    function DefaultCountryId() {
        return optional(Country::query()->where('code', '+974')->first())->id;
    }
}

if( !function_exists('HashIdObj')) {
    function HashIdObj() : Hashids {
        return new Hashids(env('HASH_ID_KEY'), 10);
    }
}

if( ! function_exists('GetSetting')) {
    function GetSetting($request) {
        if($request instanceof \Illuminate\Http\Request) {
            $key =  $request->input('key');
            $is_shown   =   1;
        } else {
            $key =  $request;
            $is_shown   =   0;
        }

        $setting = Setting::query()
            ->where('key', $key)
            ->where('is_shown', $is_shown)
            ->first();

        return $setting && $setting->type == SettingsEnum::JsonType
            ? json_decode($setting->value, true)[$request->getLanguages()[0]]
            : $setting->value;
    }
}

if ( ! function_exists('VendorAuth')) {
    function VendorAuth() {
        return auth('sanctum')->user()
            && auth('sanctum')->user()->user_type == UsersTypesEnums::Vendor;
    }
}

if ( ! function_exists('authOrNull')) {
    function authOrNull($value) {
        return auth('sanctum')->check() || request()->route()->uri == 'api/login'? $value : null;
    }
}

if(! function_exists('PaginateAttributes')) {
    function PaginateAttributes($collection, $page_attribute) {
        return [
            'pageAttribute'     =>  $page_attribute . '_page',
            'total'             =>  $collection->total(),
            'hasNext'           =>  $collection->hasMorePages(),
            'currentPage'       =>  $collection->currentPage(),
            'nextPageUrl'       =>  $collection->nextPageUrl(),
            'previousPageUrl'   =>  $collection->previousPageUrl(),
            'perPage'           =>  (int) $collection->perPage()
            ];
    }
}

if( !function_exists('UpdateShopProfile')){
    function UpdateShopProfile($request) {
        return $request->user()->user_type == UsersTypesEnums::Vendor
            ? [
            'shop_name'  =>  $request->input('shop_name'),
            'shop_name_en'  =>  $request->input('shop_name_en'),
            'whatsapp'  =>  $request->input('whatsapp'),
            'whatsapp_country_id'  =>  $request->input('whatsapp_country_id'),
            'whatsapp_country_code'  =>  $request->input('whatsapp_country_code'),
            'snapchat'  =>  $request->input('snapchat'),
            'facebook'  =>  $request->input('facebook'),
            'instagram'  =>  $request->input('instagram'),
            ]
            : [];
    }
}

if( !function_exists('UpdateUserPassword')) {
    function UpdateUserPassword($request) {
        return $request->input('password') != null
            ? ['password' => bcrypt($request->input('password'))]
            : [];
    }
}

if( !function_exists('UpdateUserEmail')) {
    function UpdateUserEmail($request) {
        return $request->input('email') != null && $request->user()->email != $request->input('email')
            ? ['email' => $request->input('email'), 'email_verified_at' => null]
            : [];
    }
}

if( !function_exists('ChangeUserImage')) {
    function ChangeUserImage($request) {
        if($request->hasFile('image')) {
            $userHashId = HashIdObj()->encode($request->user()->id);
            $ext = $request->file('image')->getClientOriginalExtension();
            $time = Str::uuid();
            $path = $request->file('image')->storeAs("users/{$userHashId}", "{$time}.{$ext}", 'public');
            optional($request->user()->profileImage)->delete();
            $request->user()->profileImage()->create(['path' => $path, 'is_default' => 1]);
        }
    }
}

if( !function_exists('deleteProductImages')) {
    function deleteProductImages($product, $request) {
        if($request->has('deleted_images_ids')) {
            $product->images()
                ->whereIn('id', $request->input('deleted_images_ids'))
                ->get()
                ->each(function($image){
                    if(Storage::disk('public')->exists($image->path)) {
                        Storage::disk('public')->delete($image->path);
                    }
                    $image->delete();
                });
        }
    }
}
if( !function_exists('uploadProductImages')) {
    function uploadProductImages($product,$request) {
        if($request->has('images')) {
            $productHashId  =   HashIdObj()->encode($product->id);
            foreach ($request->file('images') as $index => $image) {
                $ext = $image->getClientOriginalExtension();
                $time = Str::uuid();
                $path = $image->storeAs("product/{$productHashId}", "{$time}.{$ext}", 'public');
                $product->images()->create(['path' => $path, 'is_default' => $index == 0 ? 1 : 0, 'order'=>$index+1]);
            }
        }
    }
}

if(! function_exists('getSelectedLangHtml')) {
    function getSelectedLangHtml() {
        $html = [
            'en'    =>  '<i class="flag-icon flag-icon-us"></i><span class="selected-language">English</span>',
            'ar'    =>  '<i class="flag-icon flag-icon-qa"></i><span class="selected-language">عربي</span>'
        ];

        return $html[app()->getLocale()];
    }
}

if( !function_exists('getDir')) {
    function getDir() {
        return app()->getLocale() == 'ar' ? 'rtl' : 'ltr';
    }
}

if( !function_exists('isActiveHtml')) {
    function isActiveHtml($status) {
        return $status ? '<i class="fa fa-check text-success"></i>' : '<i class="fa fa-times text-danger"></i>';
    }
}

if( !function_exists('getDir')) {
    function getDir() {
        return app()->getLocale() == 'ar' ? 'rtl' : 'ltr';
    }
}

if( !function_exists('settingCollectionValue')) {
    function settingCollectionValue($settings, $key, $lang = null) {
        if($lang) {
            return json_decode(optional($settings->where('key',$key)->first())->value, true)[$lang];
        }
        return optional($settings->where('key',$key)->first())->value;
    }
}

if( !function_exists('getRoleName')) {
    function getRoleName($role){
        if($role) {
            return app()->getLocale() == 'ar' ? $role->ar_name : $role->name;
        }
    }
}

