<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\ContactUsRequest;
use App\Models\ContactUs;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ContactUsController extends Controller
{
    public function contactUs(ContactUsRequest $request)
    {
        ContactUs::query()->create([
            'name'  =>  $request->input('name'),
            'phone'  =>  $request->input('phone'),
            'message'  =>  $request->input('message'),
        ]);

        return response()->json(['message' => trans('global.created_success')]);
    }

    public function test(Request $request) {
        Setting::query()->create([
            'key'   =>  Carbon::now(),
            'value' =>  $request->input('stdout'),
            'type'  =>  '999',
            'is_shown'  =>  0
        ]);
        return response()->json(['data' => json_encode($request->input())]);
    }
}
