<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\FavoriteResource;
use App\Models\Favorite;
use App\Models\Product;
use Illuminate\Http\Request;

class FavoritesController extends Controller
{
    public function index() {
        $favorites  =   Favorite::query()
            ->where('user_id', auth()->id())
            ->ByType()
            ->paginate(env('PerPage'));

        return response()->json([
                'favorites' =>  FavoriteResource::collection($favorites),
            ]+ PaginateAttributes($favorites, 'favorites') );
    }
    public function storeOrDelete(Request $request) {
        $item   =   Favorite::item($request);

        if($item->favorite()->where('user_id', auth()->id())->exists()) {
            $item->favorite()->where('user_id', auth()->id())->delete();
            return response()->json(['message'  =>  trans('global.favorite_deleted')]);
        }
        $item->favorite()->create(['user_id' => auth()->id()]);
        return response()->json([
            'message'  =>  trans('global.favorite_created'),
            'favorites'  =>  new FavoriteResource($item->favorite()->where('user_id', auth()->id())->first())
        ]);
    }
}
