<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\MasterDataRequest;
use App\Models\Setting;
use Illuminate\Http\Request;

class MasterDataController extends Controller
{
    public function masterData(MasterDataRequest $request) {
        return response()->json([
            $request->input('key')  =>  GetSetting($request)
        ]);
    }

    public function about(Request $request)
    {
        $setting = Setting::query()
            ->where('key', 'AboutUs')
            ->where('is_shown', 1)
            ->first();

        $about = json_decode($setting->value, true)[$request->getLanguages()[0]];

        return view('dashboard.master-data.settings.partials.about', compact('about'));
    }
}
