<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\FirebaseNotification;
use App\Http\Resources\FirebaseNotifictionsResource;


class NotificationsController extends Controller
{
    public function __construct()
    {
    }

    public function index() {
        $notifications  =   FirebaseNotification::query()
            ->where('user_id', \request()->user('sanctum')->id)
            ->where('lang',app()->getLocale())
            ->orderByDesc('created_at')
            ->paginate(env('PerPage'), '*', 'notifications_page');
        return response()->json([
            'notifications' => FirebaseNotifictionsResource::collection($notifications)
        ]+ PaginateAttributes($notifications, 'notifications'));
    }

    public function deleteNotification(Request $request) {
        $notification  =   FirebaseNotification::query()
            ->where('user_id', \request()->user('sanctum')->id)
            ->find($request->input('id'));
        if($notification){
            $notification->delete();
        }
        return response()->json([
            'message'   =>  trans('global.deleted_successful')
        ]);
    }
}
