<?php


namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\VersionCheckRequest;
use App\Models\Setting;
use Cache;
class VersionController extends Controller
{
    public function index(VersionCheckRequest $request)
    {
        $app_version = [];
        $versionSettings = Cache::rememberForever('app-settings', function () {
            $settings = Setting::where('is_shown', 1)->get();
            return settingCollectionValue($settings, 'app-version');
        });
        if ($versionSettings = json_decode($versionSettings, 1)) {
            if ($request->os_type == "ios" && version_compare($request->version, $versionSettings['ios_app_version']) < 0) {
                $app_version = [
                    'version' => $versionSettings['ios_app_version'],
                    'url' => $versionSettings['ios_app_url'],
                    'message' => $versionSettings['ios_update_message']
                ];
            } elseif ($request->os_type == "android" && version_compare($request->version, $versionSettings['android_app_version']) < 0) {
                $app_version = [
                    'version' => $versionSettings['android_app_version'],
                    'url' => $versionSettings['android_app_url'],
                    'message' => $versionSettings['android_update_message']
                ];
            }
        }
        return response()->json(compact('app_version'));
    }
}
