<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Http\Filters\AbstractFilter;
use App\Http\Filters\FilterModels\CategoriesFilter;
use App\Http\Requests\ReorderCategoriesRequest;
use App\Http\Requests\UpdateCategoryRequest;
use App\Models\Category;
use App\Models\User;
use Illuminate\Http\Request;

class CategoriesController extends Controller
{
    public function index()
    {
        if (is_null(\request()->user_id)) {
            $categories = Category::query()
                ->filter(new CategoriesFilter(\request()))
                ->withCount('shops')
                ->orderBy('order')
                ->paginate(25);
        } else {
            $user = User::find(\request()->user_id);
            $categoryIds = [];
            if ($user->activeCategories->count() > 0) {
                $categoryIds = $user->activeCategories->pluck('category_id');
            }
            $categories = Category::query()
                ->filter(new CategoriesFilter(\request()))
                ->whereIn('id', $categoryIds)
                ->withCount('shops')
                ->orderBy('order')
                ->paginate(25);
        }
        $categories_orders = Category::query()
            ->filter(new CategoriesFilter(\request()))
            ->withCount('shops')
            ->orderBy('order')
            ->get();

        return view('dashboard.master-data.categories.index', ['categories' => $categories, 'categories_orders' => $categories_orders]);
    }

    public function create()
    {
        return view('dashboard.master-data.categories.create');
    }

    public function store(UpdateCategoryRequest $request)
    {
        $lastOrder = Category::query()->orderByDesc('order')->first();
        $lastOrder = $lastOrder == null ? 1 : $lastOrder->order + 1;
        Category::query()->create([
            'ar_name' => $request->input('ar_name'),
            'en_name' => $request->input('en_name'),
            'is_active' => $request->input('is_active'),
            'bg_color' => $request->input('bg_color'),
            'order' => $lastOrder
        ]);

        return redirect()->route('categories.index')->with('success', trans('global.created_success'))->withInput();
    }

    public function edit($id)
    {
        $category = Category::query()->findOrFail($id);

        return view('dashboard.master-data.categories.edit', ['category' => $category]);
    }

    public function update(UpdateCategoryRequest $request, $id)
    {
        $category = Category::query()->findOrFail($id);

        $category->update([
            'ar_name' => $request->input('ar_name'),
            'en_name' => $request->input('en_name'),
            'is_active' => $request->input('is_active'),
            'bg_color' => $request->input('bg_color')
        ]);

        return redirect()->route('categories.index')->with('success', trans('global.updated_success'))->withInput();
    }

    public function toggleCategoryStatus(Request $request)
    {
        $category = Category::query()->find($request->id);
        $category->update(['is_active' => !$category->is_active]);

        return response()->json(['status' => true, 'is_active' => $category->is_active], 200);
    }

    public function reorderCategories(ReorderCategoriesRequest $request)
    {
        foreach ($request->input('orders') as $order) {
            Category::query()->find($order['id'])->update(['order' => $order['order']]);
        }

        return redirect()->back()->with('success', trans('global.sorted_successfully'));
    }

}
