<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Http\Filters\FilterModels\CountriesFilter;
use App\Models\Country;
use Illuminate\Http\Request;

class CountriesController extends Controller
{
    public function index() {
        $countries = Country::query()
            ->filter(new CountriesFilter(\request()))
            ->paginate();

        return view('dashboard.master-data.countries.index',['countries'=>$countries]);
    }

    public function create() {
        return view('dashboard.master-data.countries.create');
    }

    public function store(Request $request) {
        $this->validate($request,[
            'ar_name'       =>  'required',
            'en_name'       =>  'required',
            'ar_currency'       =>  'required',
            'en_currency'       =>  'required',
            'code'    =>  'required',
            'is_active'     =>  'required|in:0,1'
        ]);

        $country    =   Country::query()->create([
            'ar_name'       =>  $request->input('ar_name'),
            'en_name'       =>  $request->input('en_name'),
            'ar_currency'    =>  $request->input('ar_currency'),
            'en_currency'    =>  $request->input('en_currency'),
            'code'    =>  $request->input('code'),
            'is_active'     =>  $request->input('is_active')
        ]);

        return redirect()->route('countries.index')->with('success', trans('global.created_success'));
    }

    public function edit($id) {
        $country   =   Country::query()->find($id);
        return view('dashboard.master-data.countries.edit', ['country' => $country]);
    }

    public function update(Request $request, $id) {
        $this->validate($request,[
            'ar_name'       =>  'required',
            'en_name'       =>  'required',
            'ar_currency'       =>  'required',
            'en_currency'       =>  'required',
            'code'    =>  'required',
            'is_active'     =>  'required|in:0,1'
        ]);
        $country   =   Country::query()->find($id);
        $country->update([
            'ar_name'       =>  $request->input('ar_name'),
            'en_name'       =>  $request->input('en_name'),
            'ar_currency'    =>  $request->input('ar_currency'),
            'en_currency'    =>  $request->input('en_currency'),
            'code'    =>  $request->input('code'),
            'is_active'     =>  $request->input('is_active')
        ]);

        return redirect()->route('countries.index')->with('success', trans('global.updated_success'));
    }

    public function destroy($id) {
        $country   =   Country::query()->find($id);

        if($country && $country->code != '+974') {
            $country->delete();
            return redirect()->back()->with('success', trans('global.deleted_successful'));
        }
        return redirect()->back()->with('error', trans('global.cannot_find'));
    }

    public function toggleCountryStatus(Request $request) {
        $country   =   Country::query()->find($request->id);
        $country->update(['is_active'=> !$country->is_active]);

        return response()->json(['status'=>true,'is_active'=>$country->is_active],200);
    }

}
