<?php

namespace App\Http\Controllers\Dashboard;

use App\Enums\UsersTypesEnums;
use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\Product;
use App\Models\ShopCategory;
use App\Models\User;
use Applab\Sadad\Facades\Sadad;
use Applab\Sadad\Requests\WCORequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class HomeController extends Controller
{
    public function index() {
        $admins =   Admin::query()->count();
        $shops =   User::query()->where('user_type' , UsersTypesEnums::Vendor)->count();
        $users =   User::query()->where('user_type' , UsersTypesEnums::User)->count();
        $activeSubscriptions    =   ShopCategory::query()->where('is_active' , 1)->count();
        $totalProduct           =   Product::query()->count();
        $activeProduct           =   Product::query()->where('is_active', 1)->count();
        return view('dashboard.dashboard-home.index',
            compact(
                'admins',
                'shops',
                'users',
                'activeSubscriptions',
                'totalProduct',
                'activeProduct'
            ));
    }

    public function changeLang(Request $request) {
        $lang   =   $request->input('lang');

        Session::put('local', $lang);

        if(auth('admins')->check()) {
            auth('admins')->user()->update(['lang'  =>  $lang]);
        }

        return redirect()->back();
    }
    public function purchaseSample()
    {
        $webCheckoutReq=new WCORequest();
        $webCheckoutReq->total_amount=100;
        $webCheckoutReq->order_id=$webCheckoutReq->getOrderId('SD');
        $webCheckoutReq->customer_mobile="97470138435";
        $webCheckoutReq->callback_url=url('sadad-purchased/'.$webCheckoutReq->order_id);
        $products[]=['title'=>"product name",'id'=>123,'quantity'=>1,'amount'=>1,'type'=>'line_item'];
        $webCheckoutReq->setProducts($products);
        return Sadad::webCheckoutOne($webCheckoutReq);
//        return Sadad::getTransaction('SD5576443857867');
    }
    public function purchased(Request $request,$orderId)
    {
        dd($request->all());
    }
}
