<?php

namespace App\Http\Controllers\Dashboard;

use App\Enums\NotificationTopicsEnums;
use App\Enums\NotificationTypesEnum;
use App\Enums\UsersTypesEnums;
use App\Http\Controllers\Controller;
use App\Http\Requests\NotificationRequest;
use App\Http\Traits\UploadHandler;
use App\Models\FirebaseNotification;
use App\Models\Product;
use App\Models\User;
use Illuminate\Http\Request;

class NotificationsController extends Controller
{
    use UploadHandler;

    public function index() {
        $data = null;
        if(\request()->has('type')) {
            $data = $this->getTargetDataById();
        }
        return view('dashboard.complaints_management.notifications.index', ['data'=>$data]);
    }

    public function store(NotificationRequest $request) {

//        return $request->all();
        try {
            $userType = $request->input('users_type');

            $users = User::query()
                ->when($userType != 0, function ($query) use($userType){
                $query->where('user_type', $userType);
                })
                ->get();

            $path = $this->storeNotificationImages($request);
            $path = is_null($request->input('itemImage')) ? asset("storage/{$path}") : $request->input('itemImage');

            foreach ($users as $user) {

                FirebaseNotification::query()->create([
                    'user_id'   =>  $user->id,
                    'title'     =>  $request->input('title'),
                    'body'     =>  $request->input('body'),
                    'image'     =>  $path,
                    'lang'     =>  'ar',
                    'type'      =>  $request->input('itemType') ?? NotificationTypesEnum::Empty,
                    'item_id'   =>  $request->input('itemId') ? HashIdObj()->encode($request->input('itemId')) : null
                ]);

                FirebaseNotification::query()->create([
                    'user_id'   =>  $user->id,
                    'title'     =>  $request->input('title_en'),
                    'body'     =>  $request->input('body_en'),
                    'image'     =>  $path,
                    'lang'     =>  'en',
                    'type'      =>  $request->input('itemType') ?? NotificationTypesEnum::Empty,
                    'item_id'   =>  $request->input('itemId') ? HashIdObj()->encode($request->input('itemId')) : null
                ]);
            }
            $title=$request->input('title_en')."\n". $request->input('title');
            $body =$request->input('body_en') ."\n". $request->input('body');

            fcm()
                ->toTopic(NotificationTopicsEnums::getById($userType))
                ->priority('normal')
                ->timeToLive(0)
                ->notification([
                    'title' => $title,
                    'body' =>$body,
                    'image' =>  $path,
                    'type'  =>  $request->input('itemType'),
                    'id'    =>  $request->input('itemId') ? HashIdObj()->encode($request->input('itemId')) : null
                ])->data([
                    'title' =>$title,
                    'body' => $body,
                    'image' =>  $path,
                    'type'  =>  $request->input('itemType'),
                    'id'    =>  $request->input('itemId') ? HashIdObj()->encode($request->input('itemId')) : null
                ])
                ->send();
            return redirect()->back()->with('success' , trans('global.notification_sent'));
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('error' , $e->getMessage());
        }
    }

    private function getTargetDataById() {
        $model = [
            NotificationTypesEnum::Shop => User::query(),
            NotificationTypesEnum::Product => Product::query(),
        ];
        if(array_key_exists(\request()->input('type'), $model)) {
            $item = $model[\request()->input('type')]->find(\request()->input('id'));
            return $item->notificationData();
        }
        return collect([]);
    }
}
