<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Http\Filters\FilterModels\PackagesFilter;
use App\Models\Category;
use App\Models\Package;
use Illuminate\Http\Request;

class PackagesController extends Controller
{
    public function index() {
        $packages = Package::query()
            ->filter(new PackagesFilter(\request()))
            ->paginate();

        return view('dashboard.master-data.packages.index',['packages'=>$packages]);
    }


    public function create() {
        return view('dashboard.master-data.packages.create');
    }

    public function store(Request $request) {
        $this->validate($request,[
            'ar_name'       =>  'required',
            'en_name'       =>  'required',
            'cost'          =>  'required|numeric',
            'days'          =>  'required|numeric',
            'is_active'     =>  'required|in:0,1'
        ]);
        $package = Package::query()->create([
            'ar_name'       =>  $request->input('ar_name'),
            'en_name'       =>  $request->input('en_name'),
            'cost'          =>  $request->input('cost'),
            'days'          =>  $request->input('days'),
            'is_active'     =>  $request->input('is_active')
        ]);

        Category::all()->each(fn ($cat) => $cat->packages()->attach($package->id));

        return redirect()->route('packages.index')->with('success', trans('global.created_success'));
    }

    public function edit($id) {
        $package   =   Package::query()->find($id);
        return view('dashboard.master-data.packages.edit', ['package' => $package]);
    }

    public function update(Request $request, $id) {
        $this->validate($request,[
            'ar_name'       =>  'required',
            'en_name'       =>  'required',
            'cost'          =>  'required|numeric',
            'days'          =>  'required|numeric',
            'is_active'     =>  'required|in:0,1'
        ]);
        $package   =   Package::query()->find($id);
        $package->update([
            'ar_name'       =>  $request->input('ar_name'),
            'en_name'       =>  $request->input('en_name'),
            'cost'          =>  $request->input('cost'),
            'days'          =>  $request->input('days'),
            'is_active'     =>  $request->input('is_active')
        ]);

        return redirect()->route('packages.index')->with('success', trans('global.updated_success'));
    }

    public function togglePackagesStatus(Request $request) {
        $package   =   Package::query()->find($request->id);
        $package->update(['is_active'=> !$package->is_active]);

        return response()->json(['status'=>true,'is_active'=>$package->is_active],200);
    }

    public function destroy(Package $package)
    {
        // if (!$package) {
        //     return redirect()->back()->with('error', trans('canot delete'));
        // }

        $package->delete();
        
        return redirect()->back()->with('success', trans('global.deleted_successful'));
    }

}
