<?php

namespace App\Http\Controllers\Dashboard;

use App\Enums\PaymentsEnums;
use App\Enums\UsersTypesEnums;
use App\Http\Controllers\Controller;
use App\Http\Filters\FilterModels\PaymentTransactionsFilter;
use App\Http\Filters\FilterModels\SubscriptionsFilter;
use App\Models\Category;
use App\Models\PaymentTransaction;
use App\Models\ShopCategory;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class PaymentSubscriptionController extends Controller
{
    public function __invoke()
    {
        $subscriptions  =   ShopCategory::query()
            ->with(['payment', 'shop' => function ($q) {
                $q->withTrashed();
            }, 'category'])
            ->filter(new SubscriptionsFilter(\request()))
            ->orderByDesc('created_at')
            ->paginate();

        // dd($subscriptions);

        $shops  =   User::query()->where('user_type' , UsersTypesEnums::Vendor)->select('id', 'shop_name', 'shop_name_en')->get();
        $categories  =   Category::query()->select('id', 'ar_name', 'en_name')->get();




        return view('dashboard.financial-management.payment_subscriptions.index', compact([
            'subscriptions',
            'shops',
            'categories'
        ]));
    }

    public function getSingle($id)
    {
        $subscription = ShopCategory::query()
            ->with(['payment', 'shop' => function ($q) {
                $q->withTrashed();
            }, 'package'])
            ->where('id', $id)
            ->first();
        $category = Category::query()->select('id', 'ar_name', 'en_name')->where('id', $subscription->category_id)->first();

        $status = collect([PaymentsEnums::FAILED, PaymentsEnums::PENDING, PaymentsEnums::Processing, PaymentsEnums::SUCCESS]);

        return view('dashboard.financial-management.payment_subscriptions.single', compact(['subscription', 'category', 'status']));
    }

    public function updatePaymentStatus(Request $request)
    {
        $request->validate([
            'payment_id' => ['required', 'numeric'],
            'payment_status' => ['required', Rule::in(['FAILURE', 'PENDING', 'PROCCESSING', 'SUCCESS'])]
        ]);

        $paymentStatus = PaymentTransaction::query()->where('id', $request->payment_id)->first();
        $paymentStatus->status = $request->payment_status;
        $paymentStatus->save();

        return redirect()->back()->with('success', 'Payment status updated successfully');
    }
}
