<?php

namespace App\Http\Controllers\Dashboard;

use App\Enums\UsersTypesEnums;
use App\Http\Controllers\Controller;
use App\Http\Filters\FilterModels\PaymentTransactionsFilter;
use App\Models\Category;
use App\Models\PaymentTransaction;
use App\Models\User;
use Illuminate\Http\Request;

class PaymentTransactionsController extends Controller
{
    public function index() {
        $transactions  =   PaymentTransaction::query()
            ->filter(new PaymentTransactionsFilter(\request()))
            ->orderByDesc('created_at')
            ->paginate();

        $shops  =   User::query()->where('user_type' , UsersTypesEnums::Vendor)->select('id', 'shop_name')->get();
        $categories  =   Category::query()->select('id', 'ar_name', 'en_name')->get();

        return view('dashboard.financial-management.payment_transactions.index', [
            'transactions' =>   $transactions,
            'shops' =>  $shops,
            'categories'    =>  $categories,
            ]);
    }
}
