<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class SettingsController extends Controller
{
    public function index() {
        $settings   =   Setting::query()->where('is_shown', 1)->get();
        return view('dashboard.master-data.settings.index', ['settings' => $settings]);
    }

    public function store(Request $request) {
        Cache::forget('app-settings');
        Setting::query()->where('key', 'VendorContract')->update(['value' => json_encode([
            'ar'  =>  $request->input('VendorContractAr'),
            'en'  =>  $request->input('VendorContractEn'),
        ])]);
        Setting::query()->where('key', 'PrivacyPolicy')->update(['value' => json_encode([
            'ar'  =>  $request->input('PrivacyPolicyAr'),
            'en'  =>  $request->input('PrivacyPolicyEn'),
        ])]);
        Setting::query()->where('key', 'AboutUs')->update(['value' => json_encode([
            'ar'  =>  $request->input('AboutUsAr'),
            'en'  =>  $request->input('AboutUsEn'),
        ])]);
        Setting::where('key', 'app-version')
            ->update(['value' => json_encode($request->get('app-version'))]);
        Setting::query()->where('key', 'FreeMonth')->update(['value' => $request->get('FreeMonth')]);
        Setting::query()->where('key', 'FreePackageId')->update(['value' => $request->get('FreePackageId')]);
        return redirect()->back()->with('success', trans('global.updated_success'));
    }
}
