<?php

namespace App\Http\Controllers\Dashboard;

use App\Enums\UsersTypesEnums;
use App\Http\Controllers\Controller;
use App\Http\Filters\FilterModels\UsersFilter;
use App\Http\Requests\StoreShopRequest;
use App\Http\Requests\UpdateShopRequest;
use App\Http\Traits\UploadHandler;
use App\Models\Country;
use App\Models\Product;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ShopsController extends Controller
{
    use UploadHandler;

    public function index() {
        $shops  =   User::query()
            ->filter(new UsersFilter(\request()))
            ->where(function ($q) {
                $q
                    ->where('user_type', UsersTypesEnums::Vendor)
                    ->orWhere('user_vendor', true);
            })
            ->withCount('products')
            ->withCount('activeCategories')
            ->paginate();

        return view('dashboard.users-management.shops.index',['shops'=>$shops]);
    }

    public function create() {
        $countries =   Country::query()->get();
        return view('dashboard.users-management.shops.create', ['countries' => $countries]);
    }

    public function store(StoreShopRequest $request) {
        DB::beginTransaction();
        try{
            $shop = User::query()->create([
                    'name'          =>  $request->input('name'),
                    'phone'         =>  $request->input('phone'),
                    'email'         =>  $request->input('email'),
                    'password'      =>  bcrypt(01230),
                    'is_active'     =>  $request->input('is_active', 0),
                    'user_type'     =>  UsersTypesEnums::Vendor,
                    'country_id'       =>  $request->input('country_id'),
                    'shop_name'  =>  $request->input('shop_name'),
                    'shop_name_en'  =>  $request->input('shop_name_en'),
                    'whatsapp'  =>  $request->input('whatsapp'),
                    'whatsapp_country_id'  =>  $request->input('whatsapp_country_id'),
                    'whatsapp_country_code'  =>  $request->input('whatsapp_country_code'),
                    'instagram'      =>  $request->input('instagram'),
                    'facebook'      =>  $request->input('facebook'),
                    'snapchat'      =>  $request->input('snapchat'),
                    'lang'  =>  $request->input('lang')
                ]
            );

            $this->uploadShopImage($request, $shop);
            DB::commit();
            return redirect()->action('Dashboard\ShopsController@index')->with('success', trans('global.created_success'));
        } catch (\Exception $e) {
            DB::rollBack();
//            dd($e->getMessage());
            return redirect()->back()->with('error', trans('global.something_happened'));
        }

    }

    public function edit($id) {
        $shop   =   User::query()->find($id);
        $countries =   Country::query()->get();
        return view('dashboard.users-management.shops.edit', ['countries' => $countries, 'shop' =>  $shop]);
    }

    public function update(UpdateShopRequest $request, $id) {
        DB::beginTransaction();
        try{
            $shop = User::query()
                ->where(function ($q) {
                    $q->where('user_type', UsersTypesEnums::Vendor)
                        ->orWhere('user_vendor', true);
                })
                ->find($id);
            $shop->update([
                'name'          =>  $request->input('name'),
                'phone'         =>  $request->input('phone'),
                'email'         =>  $request->input('email'),
                // 'password'      =>  bcrypt($request->input('password')),
                'is_active'     =>  $request->input('is_active', 0),
                'user_type'     =>  UsersTypesEnums::Vendor,
                'country_id'       =>  $request->input('country_id'),
                'shop_name'  =>  $request->input('shop_name'),
                'shop_name_en'  =>  $request->input('shop_name_en'),
                'whatsapp'  =>  $request->input('whatsapp'),
                'whatsapp_country_id'  =>  $request->input('whatsapp_country_id'),
                'whatsapp_country_code'  =>  $request->input('whatsapp_country_code'),
                'instagram'      =>  $request->input('instagram'),
                'facebook'      =>  $request->input('facebook'),
                'snapchat'      =>  $request->input('snapchat'),
                'lang'  =>  $request->input('lang')
            ]);
            if($request->is_active == 0) {
                $shop->tokens()->delete();
            }

            $this->uploadShopImage($request, $shop);

            DB::commit();
            return redirect()->action('Dashboard\ShopsController@index')->with('success', trans('global.updated_success'));

        } catch (\Exception $e) {
            DB::rollBack();
            // dd($e->getMessage());
            return redirect()->back()->with('error', trans('global.something_happened'));
        }

    }

    public function toggleShopStatus(Request $request) {
        $shop   =   User::query()->where('user_type', UsersTypesEnums::Vendor)->orWhere('user_vendor', true)->find($request->input('id'));
        $shop->update(['is_active'=> !$shop->is_active]);
        if(!$shop->is_active){
            $shop->tokens()->delete();
        }
        return response()->json(['status'=>true,'is_active'=>$shop->is_active],200);
    }

    public function destroy($id) {
        $shop   =   User::query()
            ->where(function ($q) {
                $q->where('user_type', UsersTypesEnums::Vendor)->orWhere('user_vendor', true);
            })
            ->find($id);
        if(!$shop) {
            return redirect()->back()->with('error', trans('global.cannot_find_shop'));
        } else {
            $shop->products()->delete();
            $shop->update([
                'phone'=>"$shop->phone-".now()->format('Y-m-d H:i:s'),
                'shop_name' => $shop->shop_name . '-DELETED',
                'shop_name_en' => $shop->shop_name_en . '-DELETED',
            ]);
            $shop->tokens()->delete();
            $shop->delete();
            return redirect()->back()->with('success', trans('global.deleted_successful'));
        }
    }
}
