<?php

namespace App\Http\Controllers\Dashboard;

use App\Enums\UsersTypesEnums;
use App\Http\Controllers\Controller;
use App\Http\Filters\FilterModels\SubscriptionsFilter;
use App\Models\Category;
use App\Models\ShopCategory;
use App\Models\User;
use Illuminate\Http\Request;

class SubscriptionsController extends Controller
{
    public function index() {
        $subscriptions  =   ShopCategory::query()
            ->filter(new SubscriptionsFilter(\request()))
            ->paginate();
        $shops  =   User::query()->where('user_type' , UsersTypesEnums::Vendor)->select('id', 'shop_name')->get();
        $categories  =   Category::query()->select('id', 'ar_name', 'en_name')->get();

        return view('dashboard.financial-management.subscriptions.index', [
            'subscriptions' =>   $subscriptions,
            'shops' =>  $shops,
            'categories'    =>  $categories,
        ]);
    }
}
