<?php


namespace App\Http\Filters;
use Illuminate\Http\Request;

abstract class AbstractFilter
{
    protected $request;

    protected $filters = [];

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function apply($builder){
        foreach ($this->resolveFilters() as $key=>$value){
            $this->resolveClass($key,$builder, $value);
        }
        return $builder;
    }

    public function resolveClass($key,$builder,$value){
        $class = $this->filters[$key];
        if(is_array($class)) {
            foreach ($class as $c) {
                (new $c($builder))->filter($value);
            }
        } else {
            (new $class($builder))->filter($value);
        }
    }

    public function resolveFilters(){
        return array_filter($this->request->only(array_keys($this->filters)), function ($value) {return !is_null($value);});
    }

}
