<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class LangMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(in_array($request->header('accept-language'), ['ar','en']) && is_null(Session::get('local')) ) {
            $local  =   $request->header('accept-language');
        } else {
            $local = Session::get('local', 'ar');
        }

        if($request->user() && $request->user()->lang != $local) {
            $request->user()->update(['lang'=>$local]);
        }

        app()->setLocale($local);

        return $next($request);
    }
}
