<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AdminCreateProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth('admins')->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'user_id'   =>  'required|exists:users,id',
            'ar_description'    =>  'sometimes',
            'en_description'    =>  'sometimes',
            'category_id'   =>  'required|exists:categories,id',
            'is_active'     =>  'required|in:0,1',
            'images'        =>  'required|array',
            'images.*'      =>  'image',
            'deleted_images'=>  'nullable|array',
            'price'         =>  'nullable|min:0',
            // 'price_after_discount'         =>  'nullable|min:0',

        ];
    }
}
