<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class MarketerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        if ($this->method() == 'POST') {
        $rules = [
            'name_ar' => 'required',
            'name_en' => 'required',
            'marketer_code' => 'required|unique:marketers,marketer_code',
        ];
        }
        elseif  ($this->method() == 'PUT'){
            $rules = [
                'name_ar' => 'required',
                'name_en' => 'required',
                'marketer_code' => 'required|string|min:4|max:8',
            ];
        }

        if(request()->has('discount_percentage') && !empty(request('discount_percentage')) ) {
            $rules['discount_percentage'] ='numeric|min:0|max:100';
        }
         return $rules;
    }
}
