<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreAdminRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth('admins')->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'  =>  'required',
            'phone' =>  'required|unique:admins,phone',
            'password'  =>  'required|min:6|confirmed',
            'image'  =>  'nullable|file|mimes:jpeg,bmp,png',
            'role_id'   =>  'required|exists:roles,id'
        ];
    }
}
