<?php

namespace App\Http\Requests;

use App\Rules\CheckShopHaveValidSubscribeCategory;
use Illuminate\Foundation\Http\FormRequest;

class StoreProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth()->check() && VendorAuth();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            //todo new CheckShopHaveValidSubscribeCategory() add to category
            'category_id'   =>  ['required'],
            'name_ar'    =>  'nullable',
            'name_en'    =>  'nullable',
            'ar_description'    =>  'nullable',
            'en_description'    =>  'nullable',
            'price' =>  'nullable|numeric',
            // 'price_after_discount' =>  'nullable|numeric',
            'images'    =>  'required|array|min:1',
            'images.*'  =>  'image|file'
        ];
    }
}
