<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth('admins')->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'  =>  'required',
            'password'  =>  'required|min:6|confirmed',
            'country_id'  =>  'required|exists:countries,id',
            'phone'  =>  'required|numeric|unique:users,phone',
            'email'  =>  'nullable|email|unique:users,email',
            'is_active'  =>  'required|in:0,1',
            'lang'  =>  'required|in:ar,en',
            'shop_image'    =>  'nullable|image',
        ];
    }
}
