<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateAdminRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth('admins')->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = request()->segment(3);
        return [
            'name'      =>  'required',
            'phone'     =>  'required|unique:admins,phone,'.$id,
            'password'  =>  'nullable|min:6|confirmed',
            'image'     =>  'nullable|file|mimes:jpeg,bmp,png',
//            'is_active' =>  'required',
//            'role_id'   =>  'required|exists:roles,id'
        ];
    }
}
