<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth('sanctum')->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'product_id'    =>  'required',
            'category_id'   =>  ['required'],
            'name_ar'    =>  'nullable',
            'name_en'    =>  'nullable',
            'ar_description'    =>  'required',
            'en_description'    =>  'nullable',
            'price' =>  'nullable|numeric',
            // 'price_after_discount' =>  'nullable|numeric',
            'images'    =>  'nullable|array|min:1',
            'images.*'  =>  'image|file',
            'deleted_images_ids'    =>  'nullable|array'
        ];
    }
}
