<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateShopRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth('admins')->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        return [
            'name'  =>  'nullable',
            // 'password'  =>  'required|min:6|confirmed',
            'country_id'  =>  'required|exists:countries,id',
            'phone'  =>  ['required','numeric',Rule::unique('users')->ignore($this->route()->shop)],
            'email'  =>  'nullable|email',
            'is_active'  =>  'required|in:0,1',
            'shop_name'  =>  ['nullable',Rule::unique('users')->ignore($this->route()->shop)],
            'shop_name_en'  => ['required',Rule::unique('users')->ignore($this->route()->shop)],
            'lang'  =>  'required|in:ar,en',
            'shop_image'    =>  'nullable|image',
            'whatsapp'  =>  'nullable|numeric',
            'whatsapp_country_id'  =>  'nullable',
            'whatsapp_country_code'  =>  'nullable',
            'instagram'  =>  'nullable',
            'facebook'  =>  'nullable',
            'snapchat'  =>  'nullable',
        ];
    }
}
