<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth('admins')->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'  =>  'required',
            'password'  =>  'nullable|min:6|confirmed',
            'country_id'  =>  'required|exists:countries,id',
            'phone'  =>  'required|numeric|unique:users,phone,'.request()->segment(3),
            'email'  =>  'nullable|email|unique:users,email,'.request()->segment(3),
            'is_active'  =>  'required|in:0,1',
            'lang'  =>  'required|in:ar,en',
            'shop_image'    =>  'nullable|image',
        ];
    }
}
