<?php

namespace App\Http\Requests\Users;

use App\Enums\UsersTypesEnums;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;


class UpdateUserProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth('sanctum')->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'  =>  [Rule::requiredIf(function () {
                return auth('sanctum')->user()->user_type == UsersTypesEnums::User;
            })],
            'email' =>  'nullable|email',
            'password'  =>  'nullable|min:6|confirmed',
            // 'shop_name'  =>  ['required', 'unique:users,shop_name','max:191'],
            //   'shop_name_en'  =>  ['required', 'unique:users,shop_name_en','max:191'],
            'image' =>  ['nullable']
        ] + (
            $this->isVendor()
                ? [
                'shop_name'  =>  ['nullable',
                 Rule::unique('users')->ignore(auth()->id(), 'id'),'max:191'],
                'shop_name_en'  =>  ['required',  Rule::unique('users')->ignore(auth()->id(), 'id'),'max:191'],
                'whatsapp'  =>  'required',
                'snapchat'  =>  'nullable',
                'facebook'  =>  'nullable',
                'instagram'  =>  'nullable',

            ]
                : []
        );
    }

    public function messages()
    {
        return [
            'whatsapp.starts_with' => trans('global.start_with_plus')
        ];
    }

    private function isVendor() {
        return auth('sanctum')->user()->user_type == UsersTypesEnums::Vendor;
    }
}
