<?php

namespace App\Http\Requests\Users;

use App\Enums\UsersTypesEnums;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UserStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth()->check() == false;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'  =>  'nullable',
            'phone' =>  'required|unique:users,phone',
            'country_id'    =>  'required|exists:countries,id',
            'password'  =>  'required|min:6|confirmed',
            'user_type' =>  'required|in:1,2'
        ] +
        (
            $this->isVendor()
                ? [
                'shop_name'  =>  ['nullable', 'unique:users,shop_name', 'max:191'],
                'shop_name_en'  =>  ['required', 'unique:users,shop_name_en', 'max:191'],
                'whatsapp'  =>  'required',
                'snapchat'  =>  'nullable',
                'facebook'  =>  'nullable',
                'instagram'  =>  'nullable',

            ]
                : []
        );
    }

    private function isVendor() {
        return $this->user_type == UsersTypesEnums::Vendor;
    }
}
