<?php

namespace App\Http\Requests;

use App\Enums\UsersTypesEnums;
use App\Models\Category;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class initialSubscriptionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return  auth()->check() and auth()->user()->user_type == UsersTypesEnums::Vendor;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'category_id'   =>  'required|exists:categories,id',
            'package_id'   =>  'required|exists:packages,id',
            'category_has_package' => Rule::requiredIf(function (){
                return Category::query()
                    ->where('id', $this->request->get('category_id'))
                    ->whereHas('packages', function ($q){
                        $q->where('id', $this->request->get('package_id'));
                    })->doesntExist();
            })
        ];
    }

    public function messages()
    {

        return [
            'category_has_package.required'  =>  trans('global.category_has_package')
        ];
    }
}
