<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'    =>  HashIdObj()->encode($this->id),
            'ar_name'  =>  $this->ar_name,
            'en_name'  =>  $this->en_name,
            'order' =>  $this->order,
            'bg_color'  =>  $this->bg_color,
            'is_subscribed' =>  $this->when(VendorAuth(), function (){
                return $this->IsShopSubscribed(auth('sanctum')->id())->exists();
            })
        ];
    }
}
