<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CategoryShopsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'    =>  HashIdObj()->encode($this->id),
            'shop_name'  =>  $this->name,
            'logo'  =>  optional($this->profileImage()->first())->full_path
        ];
    }
}
