<?php

namespace App\Http\Resources;

use App\Models\Favorite;
use Illuminate\Http\Resources\Json\JsonResource;

class FavoriteResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {

        return [
            'id'    =>  HashIdObj()->encode($this->favoriteable->id),
            'item'  =>  $this->favoriteable_type == 'user' ? new ShopResource($this->favoriteable) : new ProductsResource($this->favoriteable),
//            'image' =>  optional($this->favoriteable->defaultImage)->full_path,
//            'name'  =>  $this->when(optional($this->favoriteable)->name , function (){
//                return $this->favoriteable->name;
//            })
        ];
    }
}
