<?php

namespace App\Http\Resources;

use Hashids\Hashids;
use Illuminate\Http\Resources\Json\JsonResource;

class ShopResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
                'id'            =>  HashIdObj()->encode($this->id),
                'display_shop_name'     =>  $this->display_shop_name,
                'shop_name'     =>  $this->shop_name,
                'shop_name_en'     =>  $this->shop_name_en,
                'shop_country_flag' => $this->country->flag ? url('/flags/' . $this->country->flag . '.png') : null,
                'whatsapp'      =>  authOrNull($this->whatsapp),
                'whatsapp_country_id'      =>  authOrNull($this->whatsapp_country_id) ? $this->whatsapp_country_id : HashIdObj()->encode($this->country_id) ,
                'whatsapp_country_code'      =>  authOrNull($this->whatsapp_country_code) ? $this->whatsapp_country_code : $this->country->code,
                'instagram'     =>  authOrNull($this->instagram),
                'facebook'      =>  authOrNull($this->facebook),
                'snapchat'      =>  authOrNull($this->snapchat),
                'logo' =>  optional($this->profileImage()->first())->full_path,
                'is_favorite'   =>  $this->when(request()->user('sanctum'), function (){
                    return $this->favorite()->where('user_id', request()->user('sanctum')->id)->exists();
                }),
                'total_products' => count($this->activeProducts),
            ]
            + (
                $this->id == auth('sanctum')->id() || $request->route()->uri == 'api/login'
                ? ['shop_accept_contract'    =>  $this->shop_accept_contract]
                : []
            );
    }
}
