<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class SubscriptionsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'    =>  HashIdObj()->encode($this->id),
            'category'   =>  new CategoryResource($this->category),
            'package'   =>  [
                'id'    =>  HashIdObj()->encode($this->package_id),
                'ar_name'  =>  $this->package->ar_name,
                'en_name'  =>  $this->package->en_name,
                'cost'  =>  $this->package->cost
            ],
            'valid_to'  =>  Carbon::parse($this->valid_to)->toDateString()
        ];
    }
}
