<?php

namespace App\Http\Resources;

use App\Enums\UsersTypesEnums;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'    =>  HashIdObj()->encode($this->id),
            'name'  =>  $this->name,
            'phone' =>  $this->phone,
            'phone_verified'    =>  (int)!is_null($this->phone_verified_at),
            'country'   =>  new CountryResource($this->country),
            'email' =>  $this->email,
            'email_verified'    =>  (int)!is_null($this->email_verified_at),
            'user_type' =>  $this->user_type,
            'is_active'    =>  $this->is_active,
            'profile_image' =>  optional($this->profileImage()->first())->full_path,
            'lang'  =>  $this->lang,
            'shop'  =>  $this->when($this->user_type == UsersTypesEnums::Vendor, function () {
                return new ShopResource($this);
            })
        ];
    }
}
