<?php


namespace App\Http\Traits;


use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use Intervention\Image\Facades\Image;
use PHPUnit\Exception;

trait UploadHandler
{
    public function uploadAdminImage($request, $admin) {
        if($request->hasFile('image')) {
            $this->createDirIfNotExists('users');
            $uuid = Str::uuid();
            $imgFile = Image::make($request->file('image')->getRealPath());
            $imgFile->save(storage_path('app/public/users')."/{$uuid}.jpg", 80);
            $path = "users/{$imgFile->basename}";

            $admin->update(['image' => $path]);
        }
    }

    public function uploadShopImage($request, $shop, $imageName='shop_image') {
        if($request->hasFile($imageName)) {
            $this->createDirIfNotExists('users');
            $uuid = Str::uuid();
            $imgFile = Image::make($request->file($imageName)->getRealPath());
            $imgFile->save(storage_path('app/public/users')."/{$uuid}.jpg", 80);
            $path = "users/{$imgFile->basename}";

            optional($shop->profileImage)->delete();
            $shop->profileImage()->create(['path' => $path, 'is_default' => 1]);
        }
    }

    public function deleteProductImages(Request $request, Product $product) {
        $deletedIds = $request->input('deleted_images');
        if($deletedIds) {
            $product->images()->whereNotIn('id', $deletedIds)->delete();
        }
    }

    public function storeProductImages(Request $request, Product $product) {
        try{
            if($request->hasFile('images')) {
                $productHashId  =   HashIdObj()->encode($product->id);
                $this->createDirIfNotExists("products/{$productHashId}");
                foreach ($request->file('images') as $index => $image) {
                    $uuid = Str::uuid();
                    $imgFile = Image::make($image->getRealPath());
                    $imgFile->save(storage_path('app/public/products')."/{$productHashId}/{$uuid}.jpg", 80);
                    $path = "products/{$productHashId}/{$imgFile->basename}";

                    $product->images()->create(['path' => $path, 'is_default' => $index == 0 ? 1 : 0, 'order'=>$index+1]);
                }
            }
        } catch (Exception $e) {
            dd($e->getMessage());
        }

    }

    public function storeNotificationImages(Request $request) {
        $path = null;
        if($request->hasFile('image')) {
            $this->createDirIfNotExists('notification');
            $uuid = Str::uuid();
            $imgFile = Image::make($request->file('image')->getRealPath());
            $imgFile->save(storage_path('app/public/notification')."/{$uuid}.jpg", 90);
            $path = "notification/{$imgFile->basename}";
        }
        return $path;
    }

    private function createDirIfNotExists($dirName) {
        $path = storage_path('app/public/'.$dirName);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
        }
    }
}
