<?php

namespace App\Models;

use App\Http\Traits\hasFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Traits\HasRoles;

class Admin extends Authenticatable
{
    use hasFilter, HasRoles;

    protected $table    =   'admins';
    protected $guarded  =   ['id'];

    protected $appends  =   ['logo'];

    public function getLogoAttribute() {
        if($this->image && filter_var($this->image, FILTER_VALIDATE_URL)) { return  $this->image;}
        return is_null($this->image) ? asset('dashboard/images/logo/user.jpg') : asset("storage/{$this->image}");
    }
}
