<?php

namespace App\Models;

use App\Http\Traits\hasFilter;
use App\Http\Traits\HashIdTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model
{
    use HasFactory, SoftDeletes, HashIdTrait, hasFilter;

    protected $table    =   'categories';
    protected $guarded  =   ['id'];
    protected $appends  =   ['name'];

    public function getNameAttribute() {
        return is_null($this->en_name) || app()->getLocale() == 'ar' ? $this->ar_name : $this->en_name;
    }

    public function shops() {
        return $this->hasMany(ShopCategory::class, 'category_id', 'id');
    }

    public function packages() {
        return $this->belongsToMany(Package::class);
    }

    public function subscribedShops() {
        return $this->shops()
            ->where('is_active' , 1);
    }

    public function scopeIsShopSubscribed($query, $id) {
        return $this->subscribedShops()->where('user_id', $id);
    }
}
