<?php

namespace App\Models;

use App\Http\Traits\hasFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Country extends Model
{
    use HasFactory, SoftDeletes, hasFilter;
    protected $table    =   'countries';
    protected $guarded  =   ['id'];
    protected $appends  =   ['name', 'currency'];

    public function getNameAttribute() {
        return is_null($this->en_name) || app()->getLocale() == 'ar' ? $this->ar_name : $this->en_name;
    }

    public function getCurrencyAttribute() {
        return is_null($this->ar_currency) || app()->getLocale() == 'ar' ? $this->ar_currency : $this->en_currency;
    }
}
