<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Favorite extends Model
{
    use HasFactory;
    protected $table    =   'favorites';
    protected $guarded  =   ['id'];

    const Shop      =   1;
    const Product   =   2;
    const Types = [self::Shop => 'user', self::Product => 'product'];

    public function favoriteable() {
        return $this->morphTo();
    }

    public static function item($request) {
        return [
            self::Shop   =>  User::query()->where('id', $request->input('id'))->first(),
            self::Product   =>  Product::query()->where('id', $request->input('id'))->first(),
        ][$request->input('type')];
    }

    public function scopeByType($query) {
        return $query->where('favoriteable_type', self::Types[request()->input('type')??1]);
    }
}
