<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FirebaseNotification extends Model
{
    use HasFactory, SoftDeletes;

    protected $table    =   'firebase_notifications';
    protected $guarded  =   ['id'];
    protected $appends  =   ['image_full_path'];

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function getImageFullPathAttribute() {
        return $this->image != null
            ? (filter_var($this->image, FILTER_VALIDATE_URL)
                ? $this->image
                : asset("storage/$this->image"))
            : null;
    }
}
