<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Image extends Model
{
    use HasFactory;

    protected $table    =   'images';
    protected $guarded  =   ['id'];
    protected $appends  =   ['full_path'];

    public function imageable() {
        return $this->morphTo();
    }

    public function getFullPathAttribute() {
        return asset("storage/{$this->path}");
    }
}
