<?php

namespace App\Models;

use App\Http\Traits\hasFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Package extends Model
{
    use HasFactory, SoftDeletes, hasFilter;

    protected $table    =   'packages';
    protected $guarded  =   ['id'];
    protected $appends  =   ['name'];

    public function transactions() {
        return $this->hasMany(PaymentTransaction::class, 'package_id', 'id');
    }
    public function getNameAttribute() {
        return is_null($this->en_name) || app()->getLocale() == 'ar' ? $this->ar_name : $this->en_name;
    }
}
