<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PackageHistory extends Model
{
    use HasFactory;

    protected $fillable = [
        'shop_category_id',
        'package_id',
        'from',
        'to',
    ];

    public function shop_categories()
    {
        $this->hasMany(ShopCategory::class);
    }

    public function packages()
    {
        $this->hasMany(Package::class)->withTrashed();
    }
}
