<?php

namespace App\Models;

use App\Casts\Json;
use App\Http\Traits\hasFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentTransaction extends Model
{
    use HasFactory, hasFilter;

    protected $table    =   'payment_transactions';
    protected $guarded  =   ['id'];
    protected $casts    =   ['response'=>Json::class];

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function category() {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }

    public function package() {
        return $this->belongsTo(Package::class, 'package_id', 'id');
    }

    public function packagehistory() {
        return $this->belongsTo(Package::class, 'package_id', 'id')->withTrashed();
    }
    public function marketer() {
        return $this->belongsTo(Marketer::class, 'marketer_id', 'id');
    }
}
